<?php
/****
 * vB Optimise
 * Copyright 2010; Deceptor
 * All Rights Reserved
 * Code may not be copied, in whole or part without written permission
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

if (!is_object($vbulletin))
{
	die('Cannot access directly.');
}

define('vboptimise', true);

require_once(DIR . '/vboptimise/core/class_operator_model.php');

class vb_optimise
{
	/**
	* Opcache Operator if assigned
	*
	* @public	object
	*/
	public static $cache = null;

	/**
	* Forced Filecache Opcache Operator if assigned (for vB Cache handling)
	*
	* @public	object
	*/
	public static $writer = null;

	/**
	* Array of valid Opcache Operator models. Use register() to extend via hooks.
	*
	* @public	array
	*/
	public static $models = array(
		'none',
		'apc',
		'xcache',
		'memcache',
		'eaccelerator',
		'wincache',
		'filecache',
	);

	/**
	* Array of valid cacher libraries to be called through cache(). Use register() to extend via hooks.
	*
	* @public	array
	*/
	public static $cachers = array(
		'datastore',
		'templates',
		'style',
	);

	/**
	* String to hold user-defined cache prefix
	*
	* @public	string
	*/
	public static $prefix = '';

	/**
	* Forcefully initialises the filecache operator.
	*/
	public static function writer()
	{
		if (self::$writer != null)
		{
			return self::$writer;
		}

		require_once(DIR . '/vboptimise/core/class_operator_filecache.php');

		self::$writer = new vb_optimise_filecache;

		return self::$writer;
	}

	/**
	* Register extensions to valid Opcache Operators or Cacher Libraries via hooks.
	*
	* @param	string	Extension to register
	* @param	string	Item to register
	*/
	public static function register($to, $what = '')
	{
		if (trim($what) == '')
		{
			return fale;
		}

		if (!self::$$to || in_array($what, self::$$to))
		{
			return false;
		}

		self::$$to = array_merge(self::$$to, array($what));
		self::report('Registered ' . $what . ' to ' . $to);
	}

	/**
	* Reports internal message through to vBulletins debug combo-box.
	*
	* @param	string	Message to report
	*/
	public static function report($msg = '')
	{
		devdebug('vBOptimise: ' . $msg);
	}

	/**
	* Assigns and connects a valid Opcache Operator
	*
	* @param	string	Opcache Operator to assign
	*/
	public static function assign($model = '')
	{
		global $vbulletin;

		if (!$vbulletin->options['vbo_online'])
		{
			return false;
		}

		if (self::$cache !== null)
		{
			report('assign(' . $model . ') failed. vB Optimise already has a operator.');
			return false;
		}

		if (!in_array($model, self::$models))
		{
			trigger_error('vB Optimise could not assign the operator model \'' . $model . '\'. If you are requesting a custom operator please extend the $models array via vb_optimise::register().', E_USER_ERROR);
		}

		require_once(DIR . '/vboptimise/core/class_operator_' . $model . '.php');

		$class = 'vb_optimise_' . $model;

		self::$cache = new $class();

		if (self::$cache->connect())
		{
			self::report('Assigned Opcache Operator (' . $model . ')');
		}
		else
		{
			self::report('Unable to assign Opcache Operator (' . $model . '). vB Optimise disabled.');
			$vbulletin->options['vbo_online'] = false;
		}
	}

	/**
	* Executes a cacher library with optional arguments
	*
	* @param	string	Cache Library to execute
	* @param	mixed	Optional. Reference argument
	* @param	mixed	Optional. Reference argument
	*/
	public static function cache($what = '', &$argument = false, &$argumentb = false, &$argumentc = false)
	{
		global $vbulletin;

		if (!$vbulletin->options['vbo_online'] || !$vbulletin->options['vbo_cache_' . $what])
		{
			return false;
		}

		if (self::$cache == null)
		{
			report('cache(' . $what . ') failed. No assignment made yet.');
			return false;
		}

		if (!in_array($what, self::$cachers))
		{
			trigger_error('vB Optimise could not assign the cacher routine \'' . $what . '\'. If you are requesting a custom routine please extend the $cachers array via vb_optimise::register().', E_USER_ERROR);
		}

		require_once(DIR . '/vboptimise/cachers/cacher_' . $what . '.php');
	}

	/**
	* Triggers automatic cache flushes within Admin CP based on executions.
	*/
	public static function update()
	{
		global $vbulletin;

		if (!$vbulletin->options['vbo_online'])
		{
			return false;
		}

		self::report('Looking for conditions to flush cache automatically...');

		// ACP Actions to flush cache on
		$actions = array(
			'updatetemplate',
			'inserttemplate',
			'productimport',
			'rebuild',
			'insertstyle',
			'update',
			'displayorder',
			'savestylevar',
			'insert',
			'import',
			'replace',
		);

		if (in_array($_REQUEST['do'], $actions))
		{
			self::$cache->flush();

			self::report('Automatically flushed cache.');
		}
	}

	public static function stat($num = 0)
	{
	}
}
?>